﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4026 = {
    //general options and settings
    opts: {},

    //renders stopwatch html
    renderStopwatch: function () {
        var _me = this,
            strHTML = '';

        strHTML += ' <div id="stopwatchDialog" title="Stopwatch" style="display: none;"> ';
        strHTML += '     <div style="padding: 5px;"> ';
        strHTML += '         <div style="text-align: center;"> ';
        strHTML += '             <input id="runner" type="text" class="form-control" style="padding: 5px; font-weight: bold; font-size: 18px; text-align: center; color: #5b5b5b;" placeholder="00.0"> ';
        strHTML += '         </div> ';
        strHTML += '         <div style="margin-top: 10px; text-align: center;"> ';
        strHTML += '             <input id="btnStartStop" type="button" value="Start / Stop"/>&nbsp; ';
        strHTML += '             <input id="btnReset" type="button" value="Reset"/> ';
        strHTML += '         </div> ';
        strHTML += '     </div> ';
        strHTML += ' </div> ';

        //if ($('#stopwatchDialog').length < 1) {
            $(strHTML).appendTo($('[id$="divQuestions"]'));
            setTimeout(function () {
                _me.setStopwatch();
            }, 500);
        //}
    },

    //set the stopwatch
    setStopwatch: function () {
        $(document).ready(function () {

            //STOPWATCH
            var mClock = $('#runner').runner({
                countdown: true,
                milliseconds: true,
                startAt: (1000 * 60 * 2),
                stopAt: 0
            });

            // start/stop the clock
            $('#btnStartStop').click(function () {
                mClock.runner('toggle');
            });

            // reset the clock
            $('#btnReset').click(function () {
                mClock.runner('reset', true);
            });

            //DIALOG
            var mStopwatchDialog = $("#stopwatchDialog").dialog({
                autoOpen: false,
                beforeClose: function (event, ui) {
                    if (typeof (mClock.runner) != "undefined") {
                        mClock.runner('reset', true);
                    }
                }
            });

            $('.show-stopwatch').bind({
                click: function () {
                    mStopwatchDialog.dialog("open");
                }
            });

        });
    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    $('#stopwatchDialog').remove();
                    _me.renderStopwatch();
                    //setTimeout(function () {
                    //    _me.setStopwatch();
                    //}, 100);

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 0);
            });
        });
    }
};